# SAPI Client
This document describes the usage details of Streaming API Java client.

This project is a utility derived from the downloadable sample code on the 8x8 APIs web site.
It has been cleaned up, brought into line with our standards and turned into a general purpose
command line test utility.

The resulting JAR file is self-contained and requires a runtime Java 9 or greater version to run. It can run with 8 but this must be a version that contains the ciphers for TLS1.2

# Command Line
`java -jar sapiclient.jar`
```
usage: sapiclient
 -b,--buffer <arg>    The size of the buffer in bytes to receive events [default: 20480]
 -h,--help            Show this help
 -n,--no_reconnect    Indicates that the connection should not reconnect if it drops [default: true]
 -o,--output <arg>    The output type (XML,JSON) [default: xml]
 -req_timeout <arg>   The request timeout on making a connection in ms [default: 600]
 -retries <arg>       The number of connection retries to attempt before failing [default: 3]
 -s,--subid <arg>     Subscription ID to use to identify ourselves to SAPI [default: 8x8engineering]
 -sub_timeout <arg>   The subscription timeout (the time to stay connected whilst waiting for SAPI
                      to send events) in sec [default: 600]
 -t,--tenant <arg>    The tenant ID e.g. mytenantname01
 -tok,--token <arg>   The security token from CM for this tenant
 -url <arg>           The SAPI endpoint to connect to e.g.
                      https://vcc-eu9.8x8.com/api/streaming/v1/clientconnect/subscribe
```

# How it works
1. SAPI Java based client uses Atmosphere wAsynch library: [https://github.com/Atmosphere/wasync]
1. Client program uses the HTTP streaming mode of communication with SAPI. Read more here [http://ajaxpatterns.org/HTTP_Streaming]
1. Program is directly executable using Java command
1. To stop listening simply press CTRL+C on console or kill the program

# Client limitations
1. Only one valid subscription ID should be used at a time (there s a limit imposed by SAPI)
1. A maximum of 3 clients are allowed per tenant
1. All 3 unique clients must use separate and unique subscription ids
1. Streaming is the only available communication mechanism

_Please refer to the Streaming API documentation for more information about message description and details.
For any information/problem please contact 8x8 customer care._
